/*
 * Decompiled with CFR 0.152.
 */
package mlsoft.mct;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import mlsoft.mct.MlResource;
import mlsoft.mct.MlResourceMap;
import mlsoft.mct.MlResources;

public abstract class MlPanel
extends Panel {
    private boolean _buffer = false;
    private Image _bufferImage;
    private int _bufferWidth;
    private int _bufferHeight;
    private Graphics _bufferGC;
    private static MlResourceMap _panelResMap;
    protected MlResourceMap _resourceMap;

    public void draw() {
        this.addDirtyRect(new Rectangle(0, 0, this.getSize().width, this.getSize().height));
    }

    private void _sizeBufferImage() {
        Dimension dimension = this.getSize();
        if (dimension.width < 1) {
            dimension.width = 1;
        }
        if (dimension.height < 1) {
            dimension.height = 1;
        }
        if (this._bufferImage != null && this._bufferWidth == dimension.width && this._bufferHeight == dimension.height) {
            return;
        }
        this._bufferImage = this.createImage(dimension.width, dimension.height);
        if (this._bufferImage == null) {
            return;
        }
        this._bufferWidth = dimension.width;
        this._bufferHeight = dimension.height;
        this._bufferGC = this._bufferImage.getGraphics();
    }

    public void setBuffered(boolean bl) {
        this._buffer = bl;
    }

    public boolean getBuffered() {
        return this._buffer;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (!this._buffer) {
            this.drawView(graphics, graphics.getClipBounds());
            return;
        }
        this._sizeBufferImage();
        if (this._bufferImage == null) {
            this.drawView(graphics, graphics.getClipBounds());
            return;
        }
        this.drawView(this._bufferGC, graphics.getClipBounds());
        graphics.drawImage(this._bufferImage, 0, 0, this);
    }

    public abstract void drawView(Graphics var1, Rectangle var2);

    protected void addDirtyRect(Rectangle rectangle) {
        this.repaint(30L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private static synchronized void initResourceMap() {
        if (_panelResMap != null) {
            return;
        }
        _panelResMap = new MlResourceMap();
    }

    MlPanel() {
        MlPanel.initResourceMap();
        this._resourceMap = _panelResMap;
    }

    public void setComponentFont(Font font) {
        super.setFont(font);
    }

    public void setComponentBackground(Color color) {
        super.setBackground(color);
    }

    protected void setValuesConverted(MlResources mlResources) {
        int n = mlResources.getCount();
        int n2 = 0;
        while (n2 < n) {
            MlResource mlResource = mlResources.getResource(n2);
            if (mlResource.index == 1) {
                this.setBackground((Color)mlResource.value);
                mlResource.applied = true;
            }
            if (mlResource.index == 2) {
                this.setForeground((Color)mlResource.value);
                mlResource.applied = true;
            }
            if (mlResource.index == 3) {
                ((Component)this).setFont((Font)mlResource.value);
                mlResource.applied = true;
            }
            ++n2;
        }
    }

    public Object getValueByIndex(int n) {
        switch (n) {
            case 1: {
                return this.getBackground();
            }
            case 2: {
                return this.getForeground();
            }
            case 3: {
                return this.getFont();
            }
        }
        return null;
    }

    public boolean getBooleanValue(String string) {
        Boolean bl = (Boolean)this.getValue(string);
        if (bl instanceof Boolean) {
            return bl;
        }
        this.warning("getBooleanValue: " + string + " is not an Boolean type");
        return false;
    }

    public int getIntValue(String string) {
        Integer n = (Integer)this.getValue(string);
        if (n instanceof Integer) {
            return n;
        }
        this.warning("getIntValue: " + string + " is not an Integer type");
        return -1;
    }

    public Object getValue(String string) {
        MlResource mlResource = this._resourceMap.lookupByName(string);
        if (mlResource == null) {
            this.warning("getValue(): Unknown resource " + string);
            return null;
        }
        return this.getValueByIndex(mlResource.index);
    }

    public void setValue(String string, boolean bl) {
        this.setValue(string, new Boolean(bl));
    }

    public void setValue(String string, int n) {
        this.setValue(string, new Integer(n));
    }

    public void setValue(String string, Object object) {
        MlResources mlResources = new MlResources();
        mlResources.add(string, object);
        this.setValues(mlResources);
    }

    public void setValues(MlResources mlResources) {
        MlResource mlResource;
        this._resourceMap.convert(mlResources);
        int n = mlResources.getCount();
        int n2 = 0;
        while (n2 < n) {
            mlResource = mlResources.getResource(n2);
            mlResource.applied = false;
            ++n2;
        }
        this.setValuesConverted(mlResources);
        n = mlResources.getCount();
        n2 = 0;
        while (n2 < n) {
            mlResource = mlResources.getResource(n2);
            if (!mlResource.converted) {
                this.warning("setValues(): conversion failed for " + mlResource.name);
            } else if (!mlResource.applied) {
                this.warning("setValues(): " + mlResource.name + " was never applied");
            }
            ++n2;
        }
    }

    public void warning(String string) {
        System.out.println(String.valueOf(this.getClass()) + ": warning: " + string);
    }
}

